﻿var panel = {
    context: $(".v-panel"),
    panelSurveysTable: null,
    emailInvitationsTable: null,
    smsInvitationsTable: null,
    initializeDataTables: function () {
        panel.panelSurveysTable = $(".h-panelSurveysTable", panel.context).a4datatable({
            title: resources.PanelSurveys,
            ajaxAction: a4.getAction("GetPanelSurveys", "Home", "Panel"),
            customCallback: function () {
                $("td.v-totalCases").each(function (index) {
                    var totalCases = +$("td.v-totalCases").eq(index).text();


                    if (totalCases == 0) {
                        return;
                    }

                    var totalResponses = +$("td.v-totalResponses").eq(index).text();
                    $("td.v-totalResponses").eq(index).text(generateOutput(totalResponses, totalCases));

                    var totalCompleted = +$("td.v-totalCompleted").eq(index).text();
                    $("td.v-totalCompleted").eq(index).text(generateOutput(totalCompleted, totalCases));

                    var linkedPanelists = +$("td.v-linkedPanelists").eq(index).text();
                    $("td.v-linkedPanelists").eq(index).text(generateOutput(linkedPanelists, totalCases));

                    var panelistCompleted = +$("td.v-panelistCompleted").eq(index).text();
                    $("td.v-panelistCompleted").eq(index).text(generateOutput(panelistCompleted, totalCases));

                    var panelistNotCompleted = +$("td.v-panelistNotCompleted").eq(index).text();
                    $("td.v-panelistNotCompleted").eq(index).text(generateOutput(panelistNotCompleted, totalCases));
                });
            },
            columns: [
                { "Name": "Id", "Data": "Id", "Type": "numeric", "Title": resources.Id },
                { "Name": "Name", "Data": "Name", "Title": resources.Name, "HideInSelector": true },
                { "Name": "TotalCases", "Data": "TotalCases", "Type": "numeric", "Title": resources.TotalCases, "Class": "v-totalCases" },
                { "Name": "TotalResponses", "Data": "TotalResponses", "Type": "numeric", "Title": resources.TotalResponses, "Class": "v-totalResponses" },
                { "Name": "CompletedRespondent", "Data": "CompletedRespondent", "Type": "numeric", "Title": resources.CompletedRespondent, "Class": "v-totalCompleted" },
                { "Name": "LastAccessed", "Data": "LastAccessed", "Type": "date", "Title": resources.LastAccessed },
                { "Name": "LinkedPanelists", "Data": "LinkedPanelists", "Type": "numeric", "Title": resources.LinkedPanelists, "Class": "v-linkedPanelists" },
                { "Name": "PanelistCompleted", "Data": "PanelistCompleted", "Type": "numeric", "Title": resources.PanelistCompleted, "Class": "v-panelistCompleted" },
                { "Name": "PanelistNotCompleted", "Data": "PanelistNotCompleted", "Type": "numeric", "Title": resources.PanelistNotCompleted, "Class": "v-panelistNotCompleted" },
                { "Name": "LinkedSamples", "Data": "LinkedSamples", "Type": "numeric", "Title": resources.LinkedSamples },
                { "Name": "Points", "Data": "Points", "Title": resources.Points, "type": "numeric", "DefaultValue": "0" },
                { "Name": "TotalActiveDays", "Data": "TotalActiveDays", "Type": "numeric", "Title": resources.TotalActiveDays },
                { "Name": "TotalParticipated", "Data": "TotalParticipated", "Type": "numeric", "Title": resources.PanelistParticipated },
                { "Name": "ParticipationRate", "Data": "ParticipationRate", "Type": "numeric", "Title": resources.ParticipationRate },
                { "Name": "PanelistResponseRate", "Data": "PanelistResponseRate", "Type": "numeric", "Title": resources.PanelistResponseRate}
            ],
            stateKey: "PanelOverviewSurveys",
            defaultSorting: { Column: "LastAccessed", Ascending: false },
            contextMenuItems: [
                { "Action": "edit", "Label": resources.EditQuestionnaire },
                { "Action": "invitations", "Label": resources.Distributions },
                { "Action": "status", "Label": resources.Participation }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var self = $(this);

                if (action == "edit") {
                    window.location.href = a4.getSurveyAction("Edit", "Questionnaire", { surveyId: row.Id });
                }
                else if (action == "invitations") {
                    window.location.href = a4.getSurveyAction("Index", "Distribute", { surveyId: row.Id });

                }
                else if (action == "status") {
                    window.location.href = a4.getSurveyAction("Participation", "Analyze", { surveyId: row.Id });
                }
            },
            quickFilter: { "Items": [{ "Label": resources.Active, "AjaxParams": { "activeOnly": true } }] },
            localizableTexts: { "All": resources.AllSurveys, "Search": resources.SearchSurveys }
        });

        panel.emailInvitationsTable = $(".h-emailInvitationsTable", panel.context).a4datatable({
            title: resources.EmailInvitations,
            ajaxAction: a4.getAction("GetEmailInvitations", "Home", "Panel"),
            columns: [
                { "Name": "Id", "Data": "Id", "Type": "numeric", "Title": resources.Id },
                { "Name": "Name", "Data": "Name", "Title": resources.Name, "HideInSelector": true },
                { "Name": "SurveyName", "Data": "SurveyName", "Title": resources.SurveyName },
                { "Name": "ScheduledDateTime", "Data": "ScheduledDateTime", "Type": "date", "Title": resources.ScheduledDateTime },
                { "Name": "Status", "Data": "Status", "Title": resources.Status, "Class": "v-status" },
            ],
            stateKey: "PanelOverviewEmail",
            defaultSorting: { Column: "ScheduledDateTime", Ascending: false },
            contextMenuItems: [
                { "Action": "status", "Label": resources.Status }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var self = $(this);
                var height = 700;
                var width = 900;
                var item = data.row;

                if (item.Status == "Failed") {
                    height = 200;
                    width = 700;
                }

                if (action == "status") {
                    modalDialog.showWindow(a4.getSurveyAction("EmailInvitationStatus", "Distribute", { surveyId: row.SurveyId, id: row.Id }), height, width);
                }
            },
            quickFilter: {
                "IncludeAll": false,
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            },
            localizableTexts: { "Search": resources.SearchEmailInvitations }
        });

        var smsInvitationtable = $(".h-smsDistributionTable", panelCommon.container);

        if (smsInvitationtable.length > 0) {
            panel.smsInvitationsTable = smsInvitationtable.a4datatable({
                title: resources.SMSDistributions,
                ajaxAction: a4.getAction("GetSMSDistributions", "Home", "Panel"),
                columns: [
                    { "Name": "Id", "Data": "Id", "Type": "numeric", "Width": "6%", "Title": resources.Id },
                    { "Name": "Name", "Data": "Name", "Width": "25%", "Title": resources.Name, "HideInSelector": true },
                    { "Name": "SurveyName", "Data": "SurveyName", "Width": "25%", "Title": resources.SurveyName },
                    { "Name": "SendDate", "Data": "SendDate", "Type": "date", "Width": "17%", "Title": resources.ScheduledDateTime },
                    { "Name": "Status", "Data": "StatusEnum", "Width": "17%", "Title": resources.Status, "Class": "v-status" }
                ],
                stateKey: "PanelOverviewSMS",
                defaultSorting: { Column: "SendDate", Ascending: false },
                contextMenuItems: [
                    { "Action": "status", "Label": resources.Status }
                ],
                contextMenuClick: function (event, data) {
                    var row = data.row;
                    var action = data.action;
                    var height = 700;
                    var width = 900;
                    var item = data.row;

                    if (item.Status == "Failed") {
                        height = 200;
                        width = 700;
                    }

                    if (action == "status") {
                        modalDialog.showWindow(a4.getSurveyAction("SMSDistributionStatus", "Distribute", { surveyId: row.SurveyId, id: row.Id }), height, width);
                    }
                },
                quickFilter: {
                    "IncludeAll": false,
                    "Items": [
                        { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                        { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                        { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                        { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                    ]
                },
                localizableTexts: { "Search": resources.SearchSMSDistributions }
            });
        }

        panel.panelSurveysTable = $(".h-panelPerformanceTable", panel.context).a4datatable({
            title: resources.PanelPerformance,
            ajaxAction: a4.getAction("GetPanelPerformance", "Home", "Panel"),
            customCallback: function () {
                setPanelPerformanceStyling();
                setEventHandlers();
            },
            columns: [
                { "Name": "Name", "Data": "Name", "Type": "string", "Title": resources.Panelists, "Sortable": false, "Class": "v-panelPerformanceName" },
                { "Name": "Total", "Data": "Total", "Title": "Total", "Type": "string", "Title": resources.Total, "Class": "v-bg", "Sortable": false },
                { "Name": "LastWeek", "Data": "LastWeek", "Type": "numeric", "Title": resources.LastWeek, "Sortable": false },
                { "Name": "LastMonth", "Data": "LastMonth", "Type": "numeric", "Title": resources.LastMonth, "Sortable": false },
                { "Name": "LastSixMonths", "Data": "LastSixMonths", "Type": "numeric", "Title": resources.Last6Months, "Sortable": false },
                { "Name": "LastYear", "Data": "LastYear", "Title": resources.LastYear, "type": "numeric", "Sortable": false },
                { "Class": "v-gap", "Sortable": false, "Width": "25px", "DefaultValue": "" },
                { "Class": "v-custom-filter", "Sortable": false, "Width": "15%", "DefaultValue": "" }
            ],
            stateKey: "PanelOverviewPerformance",
            lengthMenu: [],
            displaySearchBox: false
        });
    }
}

$(document).ready(function () {
    if (panel.context.length > 0) {
        panel.initializeDataTables();
    }
});

function generateOutput(data, totalCases) {
    return data + " (" + (100 * data / totalCases).toFixed() + "%)";
}

function clearCustomFilterRows() {
    $("td.v-custom-filter").each(function (index) {
        $(this).text("");
    });
}

function setEventHandlers() {
    $(".h-clearFilter").on("click",function () {
        $(".v-fromDate").val("");
        $(".v-toDate").val("");
        clearCustomFilterRows();
    });

    $(".h-applyFilter").on("click",function () {
        var fromValue = $(".v-fromDate").val();
        var toValue = $(".v-toDate").val();
        var fromDate = new Date(fromValue);
        var toDate = new Date(toValue);

        if (fromValue === '' && toValue === '') {
            clearCustomFilterRows();
            return;
        }
        if (fromValue === '') {
            fromDate = new Date(0);
        }
        if (toValue === '') {
            toDate = new Date();
        }
        if (toDate >= fromDate) {
            a4.callServerMethod(a4.getAction("SetPanelPerformanceCustomDateFilter", "Home", "Panel"),
                { fromDate: fromDate, toDate: toDate },
                function (result) {
                    $("td.v-custom-filter").each(function (index) {
                        $(this).text(result.aaData[index].CustomFilter);
                    });
                }
            );
        } else {
            clearCustomFilterRows();
        }
    });
}

function setPanelPerformanceStyling() {
    $("td.v-panelPerformanceName").eq(0).text(resources.InvitedCompleted);
    $("td.v-panelPerformanceName").eq(1).text(resources.InvitedNotCompleted);
    $("td.v-panelPerformanceName").eq(2).text(resources.NeverCompleted);
    $("td.v-bg").eq(0).css({ "background-color": "green", "color": "white" });
    $("td.v-bg").eq(1).css({ "background-color": "orange", "color": "white" });
    $("td.v-bg").eq(2).css({ "background-color": "red", "color": "white" });

    $(".dataTables_scrollHead th.v-gap").html("");
    $(".dataTables_scrollHead th.v-custom-filter").html(
        '<span class="column-title"></span>' +
        '<input autocomplete="off" type="text" class="v-fromDate" placeholder="' + resources.From + '" style="width: 40%; margin-right: 1%">' +
        '<input autocomplete="off" type="text" class="v-toDate" placeholder="' + resources.To + '" style="width: 40%; margin-right: 5%">' +
        '<span class="icon h-applyFilter"><i class="fa fa-check"></i></span>' +
        '<span class="icon h-clearFilter"><i class="fa fa-times"></i></span>');
    $(".h-panelPerformanceTable tr").css({ "border-bottom": "none" });
    $(".v-gap").css({ "width": "2px", "background-color": "white", "color": "white", "min-width": "2px", "border-bottom": "none" });
    $(".h-panelPerformanceTable .value-column>.column-title").parent().css({ "border-bottom": "2px solid #2989b3" });

    $(".v-fromDate").datepicker({
        dateFormat: 'mm/dd/yy',
        minDate: new Date(2015, 1, 1),
        maxDate: -0,
        changeYear: true,
        changeMonth: true,

    });
    $(".v-toDate").datepicker({
        dateFormat: 'mm/dd/yy',
        minDate: new Date(2015, 1, 1),
        maxDate: -0,
        changeYear: true,
        changeMonth: true
    });
}